<?php
// v1/auth.php
require_once __DIR__.'/db.php';
require_once __DIR__.'/utils.php';

function current_user_id(?string $headerUsername) {
  if (!$headerUsername) return null; // allow anonymous GETs
  $username = trim($headerUsername);
  if ($username === '') return null;

  $pdo = get_pdo();
  $pdo->prepare("INSERT INTO users (username) VALUES (?) ON DUPLICATE KEY UPDATE username = username")
      ->execute([$username]);
  $stmt = $pdo->prepare("SELECT id FROM users WHERE username = ? LIMIT 1");
  $stmt->execute([$username]);
  $row = $stmt->fetch();
  return $row ? (int)$row['id'] : null;
}
