<?php
// v1/downloads.php
require_once __DIR__.'/db.php';
require_once __DIR__.'/utils.php';
require_once __DIR__.'/auth.php';

function log_download() {
  $pdo = get_pdo();
  $userId = current_user_id($_SERVER['HTTP_X_USERNAME'] ?? null); // allow null (anonymous)
  $b = get_json_body();
  $itemId = (int)($b['item_id'] ?? 0);
  if ($itemId <= 0) bad('item_id required');

  $chk = $pdo->prepare("SELECT 1 FROM items WHERE id=? AND published=1");
  $chk->execute([$itemId]);
  if (!$chk->fetch()) bad('Item not found', 404);

  $ins = $pdo->prepare("INSERT INTO downloads (item_id, user_id) VALUES (?,?)");
  $ins->execute([$itemId, $userId]);

  json_out(['ok'=>true]);
}
