<?php
require_once __DIR__.'/utils.php';
cors();

$method = $_SERVER['REQUEST_METHOD'];
$uri  = strtok($_SERVER['REQUEST_URI'], '?'); // strip query
$base = rtrim(dirname($_SERVER['SCRIPT_NAME']), '/');  // e.g. /api/v1
$path = '/'.trim(substr($uri, strlen($base)), '/');    // e.g. /items or /items/1

// Quick ping
if ($path === '/ping' && $method === 'GET') { json_out(['ok'=>true,'pong'=>time()]); }

require_once __DIR__.'/items.php';
require_once __DIR__.'/reviews.php';
require_once __DIR__.'/ratings.php';
require_once __DIR__.'/downloads.php';
require_once __DIR__.'/categories.php';

// /items
if ($path === '/items' && $method === 'GET') { list_items(); }

// /items/{id}
if ($method === 'GET' && preg_match('#^/items/(\d+)$#', $path, $m)) { item_detail((int)$m[1]); }

// /items/{id}/reviews
if ($method === 'GET' && preg_match('#^/items/(\d+)/reviews$#', $path, $m)) { list_reviews((int)$m[1]); }

// /reviews  (POST)
if ($path === '/reviews' && $method === 'POST') { add_review(); }

// /ratings  (POST)
if ($path === '/ratings' && $method === 'POST') { upsert_rating(); }

// /downloads (POST)
if ($path === '/downloads' && $method === 'POST') { log_download(); }

// /categories (GET)
if ($path === '/categories' && $method === 'GET') { list_categories(); }

// Fallback
bad('Not found', 404);
