<?php
// v1/ratings.php
require_once __DIR__.'/db.php';
require_once __DIR__.'/utils.php';
require_once __DIR__.'/auth.php';

function upsert_rating() {
  $pdo = get_pdo();
  $userId = current_user_id($_SERVER['HTTP_X_USERNAME'] ?? null);
  if (!$userId) bad('X-Username header required', 401);

  $b = get_json_body();
  $itemId = (int)($b['item_id'] ?? 0);
  $stars = (int)($b['stars'] ?? 0);
  if ($itemId <= 0 || $stars < 1 || $stars > 5) bad('item_id and stars (1..5) required');

  // validate item exists & published
  $chk = $pdo->prepare("SELECT 1 FROM items WHERE id=? AND published=1");
  $chk->execute([$itemId]);
  if (!$chk->fetch()) bad('Item not found', 404);

  // upsert
  $sql = "INSERT INTO ratings (item_id, user_id, stars)
          VALUES (?,?,?)
          ON DUPLICATE KEY UPDATE stars=VALUES(stars), created_at=CURRENT_TIMESTAMP";
  $pdo->prepare($sql)->execute([$itemId, $userId, $stars]);

  // return aggregates
  $agg = $pdo->prepare("SELECT avg_stars, total_ratings FROM item_rating_stats WHERE item_id=?");
  $agg->execute([$itemId]);
  $row = $agg->fetch() ?: ['avg_stars'=>0,'total_ratings'=>0];

  json_out(['ok'=>true,'avg_stars'=>(float)$row['avg_stars'],'total_ratings'=>(int)$row['total_ratings']]);
}
