<?php
// v1/reviews.php
require_once __DIR__.'/db.php';
require_once __DIR__.'/utils.php';
require_once __DIR__.'/auth.php';

function list_reviews($itemId) {
  $pdo = get_pdo();
  $page = max(1, (int)($_GET['page'] ?? 1));
  $pageSize = min(50, max(1, (int)($_GET['page_size'] ?? 20)));
  $offset = ($page-1)*$pageSize;

  $sql = "SELECT SQL_CALC_FOUND_ROWS r.id, u.username, r.created_at, r.body AS text
          FROM reviews r JOIN users u ON u.id = r.user_id
          WHERE r.item_id = ?
          ORDER BY r.created_at DESC
          LIMIT $offset, $pageSize";
  $stmt = $pdo->prepare($sql);
  $stmt->execute([(int)$itemId]);
  $reviews = $stmt->fetchAll();
  $total = (int)$pdo->query("SELECT FOUND_ROWS() AS t")->fetch()['t'];

  json_out(['page'=>$page,'page_size'=>$pageSize,'total'=>$total,'reviews'=>$reviews]);
}

function add_review() {
  $pdo = get_pdo();
  $userId = current_user_id($_SERVER['HTTP_X_USERNAME'] ?? null);
  if (!$userId) bad('X-Username header required', 401);

  $b = get_json_body();
  $itemId = (int)($b['item_id'] ?? 0);
  $text = trim($b['text'] ?? '');
  if ($itemId <= 0 || $text === '') bad('item_id and text are required');

  // validate item exists & published
  $chk = $pdo->prepare("SELECT 1 FROM items WHERE id=? AND published=1");
  $chk->execute([$itemId]);
  if (!$chk->fetch()) bad('Item not found', 404);

  $ins = $pdo->prepare("INSERT INTO reviews (item_id, user_id, body) VALUES (?,?,?)");
  $ins->execute([$itemId, $userId, $text]);

  $id = (int)$pdo->lastInsertId();
  $out = $pdo->prepare("SELECT r.id, u.username, r.created_at, r.body AS text
                        FROM reviews r JOIN users u ON u.id = r.user_id
                        WHERE r.id = ?");
  $out->execute([$id]);
  json_out(['ok'=>true,'review'=>$out->fetch()]);
}
