<?php
// v1/utils.php
function cors() {
  header('Access-Control-Allow-Origin: *');
  header('Access-Control-Allow-Headers: Content-Type, X-Username');
  header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
  if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204); exit;
  }
}

function json_out($data, int $code=200) {
  http_response_code($code);
  header('Content-Type: application/json; charset=utf-8');
  echo json_encode($data, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES);
  exit;
}
function bad($msg, int $code=400) { json_out(['ok'=>false,'error'=>$msg], $code); }
function get_json_body() {
  $raw = file_get_contents('php://input');
  $data = json_decode($raw, true);
  if ($data === null) bad('Invalid JSON body');
  return $data;
}
function qp($key,$default=null){ return $_GET[$key] ?? $default; }
function int_qp($key, $default) { $v = isset($_GET[$key]) ? (int)$_GET[$key] : $default; return max(0,$v); }
function sanitize_like($s){ return str_replace(['%','_'], ['\%','\_'], $s); }
